<?php $__env->startSection('css'); ?>
    <style>
        .reward-card {
            display: flex;
            align-items: center;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .reward-card img {
            width: 100px;
            height: 100px;
            object-fit: cover;
            border-radius: 5px;
        }

        .reward-details {
            flex: 1;
            margin-left: 15px;
        }

        .reward-title {
            font-size: 1.25rem;
            font-weight: bold;
        }

        .reward-description {
            margin: 5px 0;
        }

        .reward-points,
        .reward-quota {
            margin: 5px 0;
        }

        .card-gradient {
            background: linear-gradient(135deg, #4CAF50, #81C784);
            /* Hijau gradasi */
            color: white;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/tab-setting.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/select2.css')); ?>">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.8/js/select2.min.js"></script>

    <script>
        $(".theSelect").select2();
    </script>

    <br><br><br><br>
    <div class="container " data-aos="fade-left"><br>

        

        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10 col-sm-12">
                <div class="card card-gradient border-0 shadow-lg">
                    <div class="card-body text-center">
                        <h1 class="card-title">Hai, <span id="nameUser"></span>!</h1>
                        <p class="card-text">Ini adalah halaman dashboard profile kamu</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="card shadow mt-4" data-aos="fade-left"
            style="border-radius: 15px; border-top: 0; border-left: 0; border-bottom: 0; border-right: 5px solid rgb(32, 64, 193);">
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-8">
                        <span>Poin Anda</span>
                        <h2><b id="poin"></b></h2>
                    </div>
                    <div class="col">
                        <i class="bi bi-circle-fill d-none d-md-block me-3"
                            style="float: right; font-size: 45px; color: rgb(33, 176, 33);"></i>
                    </div>
                </div>
            </div>
        </div>
        <br>
        <br>
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="reward-tab" data-bs-toggle="tab" data-bs-target="#reward" type="button"
                    role="tab" aria-controls="reward" aria-selected="true">Reward</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="alamat-tab" data-bs-toggle="tab" data-bs-target="#alamat" type="button"
                    role="tab" aria-controls="alamat" aria-selected="true">Alamat</button>
            </li>
        </ul>

        <!-- Tab panes -->
        <div class="tab-content">
            <!-- Reward -->
            <div class="tab-pane fade show active listReward" id="reward" role="tabpanel" aria-labelledby="reward-tab">

            </div>
            <div class="tab-pane fade listAlamat" id="alamat" role="tabpanel" aria-labelledby="alamat-tab">

            </div>

            <!-- Daftar Seller Form -->
            <div class="tab-pane fade " id="seller" role="tabpanel" aria-labelledby="seller-tab">
                <form class="mt-3">
                    <div class="mb-3">
                        <label for="productCategory" class="form-label">Kategori Produk</label>
                        <input type="text" class="form-control" id="productCategory"
                            placeholder="Masukkan kategori produk">
                    </div>
                    <div class="mb-3">
                        <label for="promotionPlace" class="form-label">Tempat Promosi</label>
                        <input type="text" class="form-control" id="promotionPlace"
                            placeholder="Masukkan tempat promosi">
                    </div>
                    <div class="mb-3">
                        <label for="reason" class="form-label">Alasan</label>
                        <textarea class="form-control" id="reason" rows="3" placeholder="Masukkan alasan"></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </form>
            </div>

            <!-- Daftar Affiliator Form -->
            <div class="tab-pane fade" id="affiliator" role="tabpanel" aria-labelledby="affiliator-tab">
                <form class="mt-3">
                    <div class="mb-3">
                        <label for="territory" class="form-label">Teritori</label>
                        <input type="text" class="form-control" id="territory" placeholder="Masukkan teritori">
                    </div>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </form>
            </div>
        </div>
    </div>
    


    <section id="faq" class="faq">

        <div class="container" data-aos="fade-up">

            <header class="section-header">
                <h2>F.A.Q</h2>
                <p>Daftar pertanyaan yang paling sering ditanyakan</p>
            </header>

            <div class="row">
                <div class="col-lg-6">
                    <!-- F.A.Q List 1-->
                    <div class="accordion accordion-flush" id="faqlist1">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#faq-content-1">
                                    Apa itu Balanja.id?
                                </button>
                            </h2>
                            <div id="faq-content-1" class="accordion-collapse collapse" data-bs-parent="#faqlist1">
                                <div class="accordion-body">
                                    My bisnis adalah Perusahaan distributor modern yang penjualannya melalui platform my
                                    bisnis secara online dan terintegrasi
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#faq-content-2">
                                    Bagaimana cara menjadi afiliator Balanja.id ??
                                </button>
                            </h2>
                            <div id="faq-content-2" class="accordion-collapse collapse" data-bs-parent="#faqlist1">
                                <div class="accordion-body">
                                    Silahkan isi form online afiliator yang telah disediakan nanti CS dari Balanja.id
                                    akan menghubungi anda
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#faq-content-3">
                                    Bagaimana cara menjadi cabang Balanja.id ??
                                </button>
                            </h2>
                            <div id="faq-content-3" class="accordion-collapse collapse" data-bs-parent="#faqlist1">
                                <div class="accordion-body">
                                    Silahkan isi form online cabang yang telah disediakan nanti CS dari Balanja.id akan
                                    menghubungi anda
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="col-lg-6">

                    <!-- F.A.Q List 2-->
                    <div class="accordion accordion-flush" id="faqlist2">

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#faq2-content-1">
                                    Apa keuntungan bergabung menjadi afiliator Balanja.id ?

                                </button>
                            </h2>
                            <div id="faq2-content-1" class="accordion-collapse collapse" data-bs-parent="#faqlist2">
                                <div class="accordion-body">
                                    Sangat banyak sekali dimulai dari komisi, inestif , bonus dan pengembangan diri

                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#faq2-content-2">
                                    Saya gaptek apakah bisa gabung di Balanja.id ?

                                </button>
                            </h2>
                            <div id="faq2-content-2" class="accordion-collapse collapse" data-bs-parent="#faqlist2">
                                <div class="accordion-body">
                                    Sangat bisa asal mau berusaha dan kerja keras, karena mybisnis akan memberikan
                                    strategi penjualan yang laris di dunia online
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#faq2-content-3">
                                    Berapa biaya untuk bergabung menjadi afiliator Balanja.id ??

                                </button>
                            </h2>
                            <div id="faq2-content-3" class="accordion-collapse collapse" data-bs-parent="#faqlist2">
                                <div class="accordion-body">
                                    <b> GRATIS !! </b> bisa di katakana gratis karena anda hanya membeli produk saja
                                    untuk bahan konten anda maka anda sudah berhak menjadi afiliator di mybisnis.

                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

        </div>

    </section>
    <center>
        <a class="btn btn-primary" href="/logout">LOGOUT</a>
    </center>

    <style>
        .pilih-foto {
            border: 1px solid rgb(34, 183, 34);
            color: rgb(34, 183, 34);
            width: 75%;
        }

        .pilih-foto:hover {
            border: 1px solid rgb(34, 183, 34);
            background: rgb(34, 183, 34);
            color: white;
        }
    </style>


    <div class="modal fade" id="profil" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content ">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">EDIT PROFIL
                    </h5>
                </div>
                <div class="modal-body">
                    <form action="/member/profil/edit" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        
                        <div class="form-group mb-2">
                            <label>Nama Lengkap</label>
                            <div class="input-group ">
                                <input type="text" value="" placeholder="Masukan nama lengkap" name="name"
                                    autocomplete='off' class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class=" form-group mb-2">
                            <label>Tanggal Lahir</label>
                            <input class="form-control <?php $__errorArgs = ['tgl_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value=""
                                name="tgl_lahir" type="date" autocomplete='off' required>
                            <?php $__errorArgs = ['tgl_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="row mb-2">
                            <div class="form-group col">
                                <label>Jenis Kelamin</label>
                                <select name="jenis_kelamin"
                                    class="form-control <?php $__errorArgs = ['jenis_kelamin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="Laki-laki">Laki-laki</option>
                                    <option value="Perempuan">Perempuan</option>
                                </select>
                                <?php $__errorArgs = ['jenis_kelamin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col">
                                <label>Agama</label>
                                <select name="agama" class="form-control <?php $__errorArgs = ['agama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="Islam">Islam</option>
                                    <option value="Hindu">Hindu</option>
                                    <option value="Kristen">Kristen</option>
                                    <option value="Budha">Budha</option>
                                </select>
                                <?php $__errorArgs = ['agama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class=" form-group mb-2">
                            <label>No. Telepon</label>
                            <input class="form-control <?php $__errorArgs = ['no_telepon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value=""
                                name="no_telepon" type="number" autocomplete='off' required>
                            <?php $__errorArgs = ['no_telepon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn text-white form-control"
                        style="background: rgb(19, 180, 19);">Simpan
                        Perubahan</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="akun" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content ">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">EDIT AKUN
                    </h5>
                </div>
                <div class="modal-body">
                    <div class="alert alert-warning" role="alert">
                        <i class="fa-solid fa-triangle-exclamation mr-1"></i>
                        Isi data dibawah jika ingin mengubah Email atau Password anda.
                    </div>
                    <form action="/member/profil/editAkun/" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group mb-2">
                            <label>Alamat Email</label>
                            <div class="input-group ">
                                <input type="text"" placeholder="Masukan alamat email" name="email"
                                    autocomplete='off' class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group mb-2">
                            <label for="current">Password Lama</label>
                            <input type="password" name="current_password" autocomplete="off"
                                placeholder="Masukan Password Lama"
                                class="form-control <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group mb-2">
                            <label for="password" class="label">Password Baru</label>
                            <input id="password" type="password"
                                class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password"
                                placeholder="Masukan Password Baru" autocomplete="new-password" required>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group mb-2">
                            <label for="konfirmasi">Konfirmasi Password</label>
                            <input type="password" name="password_confirmation" autocomplete="off"
                                placeholder="Konfirmasi Password Baru"
                                class="form-control <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn text-white form-control"
                        style="background: rgb(19, 51, 180);">Simpan
                        Perubahan</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="alamat" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content ">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Tambah Alamat Baru
                    </h5>
                </div>
                <div class="modal-body">
                    <h5 class="mb-3"><b>Lengkapi detail alamat</b></h5>
                    <form action="alamat/tambah" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group mb-2">
                            <label>Label Alamat</label>
                            <div class="input-group ">
                                <input type="text" value="<?php echo e(old('label_alamat')); ?>" placeholder=""
                                    name="label_alamat" autocomplete='off'
                                    class="form-control <?php $__errorArgs = ['label_alamat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <?php $__errorArgs = ['label_alamat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <span class="text-secondary" style="font-size: 13px;">Rumah, Kantor, Apartemen, Kos</span>
                        </div>
                        <div class="form-group mb-2">
                            <label>Alamat Lengkap</label>
                            <div class="input-group ">
                                <textarea placeholder="" name="alamat_lengkap" class="form-control <?php $__errorArgs = ['alamat_lengkap'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    required rows="3"><?php echo e(old('alamat_lengkap')); ?> </textarea>
                                <?php $__errorArgs = ['alamat_lengkap'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group mb-2">
                            <label>Catatan untuk kurir (opsional)</label>
                            <div class="input-group ">
                                <input type="text" value="<?php echo e(old('patokan')); ?>" placeholder="" name="patokan"
                                    autocomplete='off' class="form-control <?php $__errorArgs = ['patokan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <?php $__errorArgs = ['patokan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <span class="text-secondary" style="font-size: 13px;">Warna rumah, patokan, pesan khusus,
                                dll.</span>
                        </div>
                        <div class="form-group mb-3">
                            <label>Nama Penerima</label>
                            <div class="input-group ">
                                <input type="text" value="" placeholder="" name="nama_penerima"
                                    autocomplete='off' class="form-control <?php $__errorArgs = ['nama_penerima'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    required>
                                <?php $__errorArgs = ['nama_penerima'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <label>Nomor HP</label>
                            <div class="input-group ">
                                <input type="text" value="" placeholder="" name="no_hp" autocomplete='off'
                                    class="form-control <?php $__errorArgs = ['no_hp'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <?php $__errorArgs = ['no_hp'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <button type="submit" class="btn w-100 text-white" style="background: rgb(20, 169, 20);">Tambah
                            Alamat</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="rekening" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content ">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Mau tambah rekening apa?
                    </h5>
                </div>
                <div class="modal-body">
                    <form action="rekening/tambah" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group mb-2">
                            <label>Nama Bank</label>
                            <div class="input-group ">
                                <select name="id_bank" required
                                    class="form-control form-control
                                    theSelect"
                                    <?php $__errorArgs = ['id_bank'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>>
                                    <option value="">Pilih Nama Bank</option>
                                    </option>
                                    
                                </select>
                                <?php $__errorArgs = ['id_bank'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="form-group mb-2">
                            <label>Nomor Rekening </label>
                            <div class="input-group ">
                                <input type="number" value="<?php echo e(old('no_rekening')); ?>"
                                    placeholder="Masukkan nomor rekening" name="no_rekening" autocomplete='off'
                                    class="form-control <?php $__errorArgs = ['no_rekening'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <?php $__errorArgs = ['no_rekening'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label>Nama Pemilik</label>
                            <div class="input-group ">
                                <input type="text" value="<?php echo e(old('nama_pemilik')); ?>"
                                    placeholder="Masukkan Nama Pemilik" name="nama_pemilik" autocomplete='off'
                                    class="form-control <?php $__errorArgs = ['nama_pemilik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <?php $__errorArgs = ['nama_pemilik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="alert" style="background: whitesmoke;">
                            <i class="bi bi-info-circle"></i> Dengan klik tombol di bawah, kamu menyetujuiSyarat &
                            KetentuansertaKebijakan Privasiuntuk menambahkan rekening.
                        </div>
                        <button type="submit" class="btn w-100 text-white" style="background: rgb(20, 169, 20);">Tambah
                            Rekening</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script>
        var API_URL = document.querySelector('meta[name="api-url"]').getAttribute('content');
        var API_SECRET = document.querySelector('meta[name="api-secret"]').getAttribute('content');
        if (user) {
            document.getElementById('nameUser').innerHTML = JSON.parse(user).karyawan.nama_lengkap
        } else {
            window.location.href = "/login"
        }

        var poin;

        getPoin()
        getAlamat()

        function getPoin() {
            var token = localStorage.getItem('token')
            var user = JSON.parse(localStorage.getItem('user'))
            axios.get(
                    `${API_URL}/v1/poin/index-rekap?member_id=${user.karyawan.id}&type=konsumen`, {
                        headers: {
                            'secret': API_SECRET,
                            'Author': 'bearer ' + token,
                            'device': 'web'
                        }
                    })
                .then(function(response) {
                    poin = response.data
                    $('#poin').html(poin.dapat_ditarik)
                    getReward()
                })
                .catch(function(error) {
                    // handle error
                    console.log(error);
                });




        }

        function getReward() {
            var token = localStorage.getItem('token')
            axios.get(
                    `${API_URL}/v1/reward`, {
                        headers: {
                            'secret': API_SECRET,
                            'Author': 'bearer ' + token,
                            'device': 'web'
                        }
                    })
                .then(function(response) {
                    let reward = response.data.data
                    $.each(reward, function(key, value) {
                        $('.listReward').append(`
                                <div class="reward-card mt-4">
                                    <img src="${value.patch}" alt="Reward Image">
                                    <div class="reward-details">
                                        <h5 class="reward-title">${value.judul}</h5>
                                        <div class="reward-description">${value.keterangan}</div>
                                        <div class="reward-points"> <strong> ${value.nilai} Poin </strong> </div>
                                        <div class="reward-quota">Kuota: ${value.kouta}</div>
                                        <button ${value.nilai > poin.dapat_ditarik ? "disabled" : ""  } class="btn btn-success" onclick='redeemReward(${JSON.stringify(value)})'>Redeem </button>
                                    </div>
                                </div>
                            `)
                    })
                })
                .catch(function(error) {
                    // handle error
                    console.log(error);
                });




        }

        function redeemReward(reward) {
            var user = JSON.parse(localStorage.getItem('user'))
            Swal.fire({
                title: 'Anda Yakin',
                text: 'Anda akan me-redeem reward ini?',
                icon: 'peringatan',
                showCancelButton: true,
                confirmButtonText: 'Ya',
                cancelButtonText: 'Tidak'
            }).then((result) => {
                if (result.isConfirmed) {
                    var token = localStorage.getItem('token')
                    payload = {
                        member_id: user.karyawan.id,
                        reward_id: reward.id,
                    }

                    axios.post(`${API_URL}/v1/pengajuan-reward`, payload, {
                            headers: {
                                'secret': API_SECRET,
                                'Author': 'bearer ' + token,
                                'device': 'web',

                            }
                        })
                        .then(function(response) {
                            Swal.fire('Berhasil!', 'Reward berhasil di redeem', 'success');
                            getPoin()
                        })
                        .catch(function(error) {
                            // handle error
                            alert(error.response.data.message)
                        });


                }
            });
        }

        function getAlamat() {
            var token = localStorage.getItem('token')
            axios.get(`${API_URL}/v1/member/index-alamat?member_id=${JSON.parse(user).karyawan.id}`, {
                    headers: {
                        'secret': API_SECRET,
                        'Author': 'bearer ' + token,
                        'device': 'web'
                    }
                })
                .then(function(response) {
                    let alamatSaya = response.data.data
                    if (alamatSaya[0]) {
                        $('.listAlamat').html("")
                        $('.listAlamat').append(`
                              <a href="/tambah-alamat-saya?pass_cart=profile" class="mt-4 btn btn-primary text-white w-100 btn-lg">+
                        Tambah Alamat Baru</a><br><br>
                        `)
                        $.each(alamatSaya, function(key, value) {
                            $('.listAlamat').append(`
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="">
                                                <span class="text-bold"
                                                    style="color: gray;">${value.label_alamat}</span>
                                                <h5><b>${value.nama_kontak}</b></h5>
                                                <span>${value.nomor_kontak}</span>
                                                <span>${value.label_alamat}
                                                    (${value.catatan})
                                                </span>
                                            </div>
                                            <div>
                                                <a class="btn mt-2 me-2 float-end" style="background: rgb(225, 225, 0); color: white;" href="/edit-alamat-saya/${value.id}?pass_cart=profile">Edit</a>
                                                <button type="button" class="btn mt-2 me-2 float-end" onclick='hapusAlamat(${value.id}, ${JSON.stringify(value)}, ${JSON.stringify(alamatSaya)})'
                                                    style="background: rgb(255, 0, 0); color: white;">Hapus</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `)
                        })
                    } else {
                        $('#alamatKonsumen').html(`
                        <div class="card-header bg-white">
                            <a href="/tambah-alamat-saya?pass_cart=${params.pass_cart}" class="btn text-white col-sm-3 btn-sm"
                            style=" background: rgb(15, 180, 15);">+ Tambah Alamat Baru</a>
                        </div>
                        `)
                    }
                })
                .catch(function(error) {
                    // handle error
                    console.log(error);
                });


        }

        function hapusAlamat(idAlamat, value, alamatSaya) {
            Swal.fire({
                title: 'Peringatan',
                text: 'Anda yakin ingin menghapus data alamat ini?',
                icon: 'peringatan',
                showCancelButton: true,
                confirmButtonText: 'Ya',
                cancelButtonText: 'Tidak'
            }).then((result) => {
                if (result.isConfirmed) {
                    var token = localStorage.getItem('token')
                    payload = {
                        id: idAlamat
                    }

                    axios.post(`${API_URL}/v1/member/delete-alamat`, payload, {
                            headers: {
                                'secret': API_SECRET,
                                'Author': 'bearer ' + token,
                                'device': 'web',

                            }
                        })
                        .then(function(response) {
                            Swal.fire('Berhasil!', 'Alamat terhapus', 'danger');
                            getAlamat()
                        })
                        .catch(function(error) {
                            // handle error
                            alert(error.response.data.message)
                        });


                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.member', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digma/public_html/balanja/resources/views/member/profil.blade.php ENDPATH**/ ?>